SELECT * FROM animal;
SELECT * FROM breed;


SELECT  animal_name, breed_name, b.breed_id
FROM animal a JOIN breed b
     ON a.breed_id = b.breed_id
ORDER BY animal_name;

SELECT  a.animal_name, b.breed_name, b.breed_type
FROM animal a JOIN breed b
     ON a.breed_id = b.breed_id
WHERE b.breed_type = 'dog'
ORDER BY 1;

-- Quidditch Problem 1
SELECT animal_name, vol_first, vol_last, vol_city
FROM animal a JOIN Volunteer v
     ON a.vol_id = v.vol_id
ORDER BY 1;

-- Quidditch Problem 2
SELECT animal_name, arrival_date, vol_first, vol_last, vol_city
FROM animal a JOIN Volunteer v
     ON a.vol_id = v.vol_id
WHERE a.arrival_date LIKE '2022%'
ORDER BY 1;  -- Order by animal_name

SELECT CONCAT(adopter_first, ' ', adopter_last) AS Adopter, breed_name
FROM adopter a JOIN wishlist w   
ON a.adopter_id = w.adopter_id 
JOIN breed b ON b.breed_id = w.desired_breed
ORDER BY breed_name;

-- Quidditch Problem 3
SELECT v.vol_last AS "Volunteer", a.animal_name AS "Animal", 
        b.breed_name as "Breed", b.breed_type AS "Type"
FROM volunteer v JOIN animal a ON v.vol_id = a.vol_ID
JOIN breed  b ON a.breed_id = b.breed_id
ORDER BY vol_last;

-- Quidditch Problem 4 (next class - before GROUP functions)
SELECT c.city AS "City", co.country AS "Country", c.country_id
FROM city c JOIN country co on c.country_id = co.country_id
ORDER BY 1;

-- Quidditch Problem 5
SELECT COUNT(*) AS "Number of Payments", 
       SUM(amount) AS "Total Payments", 
       AVG(amount) AS "Average Payment"
FROM payment;

-- GROUP FUNCTIONS
SELECT Count(*) AS 'Number of Animals'
FROM animal;

SELECT AVG(Animal_Age) AS 'Average age of Animals'
FROM animal;

-- Quidditch Problem 5
SELECT COUNT(amount) AS "Number of Payments", SUM(amount) AS "Total Payments", 
AVG(amount) AS "Average Payment"
FROM payment;

-- GROUP BY Problem
SELECT customer_id AS "Customer ID", COUNT(*) AS "Number of Payments", 
SUM(amount) AS "Total Payments", ROUND(AVG(amount), 2) AS "Average Payment"
FROM payment
GROUP BY customer_id
ORDER BY customer_id;

-- GROUP BY with HAVING clause
SELECT customer_id AS "Customer ID", COUNT(*) AS "Number of Payments", 
SUM(amount) AS "Total Payments", ROUND(AVG(amount), 2) AS "Average Payment"
FROM payment
GROUP BY customer_id
HAVING SUM(Amount) > 175
ORDER BY SUM(Amount);

-- Quidditch Problem 6
SELECT Staff_id AS "Staff ID", Count(customer_id) AS "Number of Customers",
MAX(rental_id) AS "Largest Rental ID", MIN(rental_id) AS "Smallest Rental ID"
FROM Rental
GROUP BY staff_id
ORDER BY 1;

-- Quidditch Problem 7 (next class - before Nested queries)
SELECT vol_id, COUNT(*) AS "Number", 
     AVG(animal_age) AS "Average Age",  
     MIN(animal_age) AS "Youngest", MAX(animal_age) AS "Oldest"
FROM animal
GROUP BY vol_id
HAVING COUNT(*) >= 2
ORDER BY 2 DESC;


-- Nested queries
-- Example 1.  Write the subquery
SELECT vol_city                  			   
FROM volunteer                  			   
WHERE vol_first = 'Alice' AND vol_last = 'Ledet';

-- Combine with the outer query
SELECT vol_id, vol_first, vol_last
FROM volunteer
WHERE vol_city = (SELECT vol_city                  			   
                   FROM volunteer                  			   
                   WHERE vol_first = 'Alice' AND vol_last = 'Ledet');

-- Example 2:  List the animal's name and arrival year for those animals
-- whose arrival date is the same as Coco's

-- Write the subquery
SELECT Year(arrival_date)
FROM animal
WHERE animal_name = 'Coco';

SELECT animal_name, arrival_date
FROM animal
WHERE YEAR(arrival_date) = (SELECT YEAR(arrival_date)
FROM animal
WHERE animal_name = 'Coco');

-- QUidditch Problem 8
SELECT adopter_first, adopter_last, adopter_id
FROM adopter 
WHERE adopter_id = (SELECT vol_id
					FROM volunteer
                    WHERE vol_first = 'Mimi' AND vol_last = 'Jannik');


